<?php

namespace Drupal\langfuse\EventSubscriber;

use Drupal\langfuse\LangFuseClientInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Event\TerminateEvent;

/**
 * Event Subscriber for syncing LangFuse traces at the end of the request.
 */
class LangfuseSyncSubscriber implements EventSubscriberInterface {

  /**
   * The LangFuse client service.
   *
   * @var \Drupal\langfuse\LangFuseClientInterface
   */
  protected LangFuseClientInterface $langFuseClient;

  /**
   * Constructs a new LangfuseSyncSubscriber.
   *
   * @param \Drupal\langfuse\LangFuseClientInterface $langFuseClient
   *   The LangFuse client service.
   */
  public function __construct(LangFuseClientInterface $langFuseClient) {
    $this->langFuseClient = $langFuseClient;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      // Kernel Terminate has lower priority to ensure other
      // operations complete.
      KernelEvents::TERMINATE => ['onKernelTerminate', 100],
    ];
  }

  /**
   * Handles the Kernel Terminate event.
   *
   * @param \Symfony\Component\HttpKernel\Event\TerminateEvent $event
   *   The terminate event.
   */
  public function onKernelTerminate(TerminateEvent $event) {
    // Only attempt to sync traces if LangFuse is properly configured.
    if ($this->langFuseClient->isConfigured()) {
      $this->langFuseClient->syncTraces();
    }
  }

}
