# LangFuse

🚀 Comprehensive AI observability and analytics for Drupal applications.

Built on the powerful
[Dropsolid LangFuse PHP SDK](https://packagist.org/packages/dropsolid/langfuse-php-sdk)
([GitLab repo](https://gitlab.com/dropsolid/langfuse-php-sdk)), this module
integrates seamlessly with the [LangFuse](https://langfuse.com) observability
platform to provide detailed tracking, analytics, and insights for all your AI
interactions.

**Requirements:** PHP 8.1+ (uses modern PHP features like readonly properties)

[1. Main Dashboard Screenshot - showing LangFuse dashboard with Drupal AI
traces]

## ✨ Key Features

- 🔄 **Zero-Configuration AI Tracking**: Automatically captures all AI.module
  interactions
- 🎯 **Unified Request Tracing**: Groups multiple AI operations (embeddings +
  chat) into single traces
- 📊 **Comprehensive Analytics**: Token usage, response times, and model
  performance metrics
- 🔐 **Multiple Authentication Methods**: Bearer tokens, API keys, basic auth,
  and self-hosted support
- ⚡ **Production Ready**: Built with proper error handling, caching, and
  performance optimization
- 🛠️ **Developer Friendly**: Rich debugging information and extensible
  architecture

## 🚀 Quick Start

### Requirements

- **Drupal**: 10.x or 11.x
- **PHP**: 8.1 or higher
- **LangFuse Account**: [Cloud](https://cloud.langfuse.com) or
  [self-hosted](https://langfuse.com/docs/deployment/self-host) (fully free,
  here's [Docker Compose](https://langfuse.com/self-hosting/docker-compose))

### Installation

```bash
# Install the module via Composer
composer require drupal/langfuse

# Enable the core module
drush en langfuse -y

# Optional: Enable AI.module integration (recommended)
drush en langfuse_ai_logging -y

# Optional: Enable example demonstrations
drush en langfuse_example -y
```

### Configuration

1. **Navigate to the settings page**: `/admin/config/system/langfuse/settings`
2. **Enter your LangFuse URL**: e.g., `https://cloud.langfuse.com` or your
   self-hosted URL
3. **Choose authentication method**: API key pair (recommended), bearer token,
   or basic auth
4. **Enter your credentials**: Get these from your LangFuse project settings
5. **Save configuration**: The system will test your connection automatically

[2. Configuration Form Screenshot - showing the LangFuse settings form with
authentication options]

## 🎯 How It Works

Once configured with the `langfuse_ai_logging` submodule enabled, **every
AI.module interaction is automatically logged** - no code changes required!

This includes:

- **Programmatic AI calls**: `$ai_provider->generateText('Your prompt')`
- **AI Explorer page**: Built-in AI.module interface at
  `/admin/config/ai/explorer`
- **Any AI.module integration**: Chat forms, embeddings, moderation, etc.

```php
// This request will be automatically tracked in LangFuse
$ai_provider = \Drupal::service('ai.provider');
$response = $ai_provider->generateText('Explain quantum computing');
```

[3. Trace Details Screenshot - showing a Drupal AI request trace in LangFuse
with generations, timing, and usage data]

[4. AI Explorer Screenshot - showing the AI.module explorer page that gets
automatically tracked]

## 📦 Module Architecture

### Core Module (`langfuse`)

The foundation module providing:

- **LangFuse Client Service** (`langfuse.client`): Main interface to the
  LangFuse SDK
- **Configuration Management**: Secure credential storage with multiple auth
  methods
- **Connection Testing**: Automatic validation of LangFuse connectivity

### AI.module Integration (`langfuse_ai_logging`)

Automatic observability for the entire AI.module ecosystem:

- **Event-Driven Architecture**: Subscribes to AI.module pre/post generation
  events
- **Unified Request Tracing**: Creates single traces containing multiple AI
  operations
- **Zero Developer Effort**: Works automatically with any AI.module integration

### AI Agents Tool Logging (`langfuse_ai_agents_logging`)

Instrumentation specifically for the [AI Agents module](https://www.drupal.org/project/ai_agents):

- **Tool Span Tracking**: Every tool execution becomes a LangFuse span with input/output metadata.
- **Delegation Awareness**: Nested agents inherit the parent runner context so spans nest correctly.
- **Dependency Isolation**: Lives in its own submodule so sites not using AI Agents avoid the extra dependency.

### AI Search Logging (`langfuse_ai_search_logging`)

Observability for Search API based Retrieval-Augmented Generation (RAG):

- **Search API Events**: Wraps `search_api` query pre/post execute to capture retrieval spans.
- **Embedding Parenting**: Retrieval spans automatically become the parent of downstream embedding requests.
- **Split Motivation**: The AI Search integration depends on `search_api` and `ai_search`; keeping it separate avoids forcing these modules on every installation.

## 🧠 Runner Context & Span Management

To keep spans properly nested across multiple subsystems we maintain a lightweight “runner context” in `LangFuseTraceManager`:

- **Runner Parents**: Every AI agent execution receives a unique runner ID. When an agent delegates to another agent, we record the caller ID so spans can hook into the correct parent.
- **Pending Tool Parents**: When a generation schedules a tool call, we queue that generation as the parent. The tool span claims (and later releases) the queue entry ensuring one-to-one relationships.
- **Delegation Spans**: Tool spans triggered by nested agents register themselves as delegation parents so the child agent’s generation attaches correctly.
- **Named Span Contexts**: Stack-like helpers (e.g., `ai_search.tool`, `ai_search.retrieval`) allow other systems such as Search API to discover the active parent without knowing the implementation details.

This approach keeps each subscriber very small while guaranteeing that the final LangFuse trace mirrors the real execution hierarchy.

### Example Implementation (`langfuse_example`)

Demonstrates low-level LangFuse integration patterns:

- **OpenAI Demo Form**: Interactive example with chat completions
- **Manual Trace Management**: Shows how to create custom traces outside
  AI.module

[5. Complete Workflow GIF - showing user using AI Explorer → request → trace
appearing in LangFuse dashboard]

## 🔗 Resources

- **LangFuse Official Docs**: <https://langfuse.com/docs>
- **AI.module Documentation**: <https://www.drupal.org/project/ai>
- **Dropsolid LangFuse PHP SDK**:
  <https://packagist.org/packages/dropsolid/langfuse-php-sdk>

---

**Module Maintainers**: Dropsolid Team
**License**: GPL-2.0-or-later
**Drupal Compatibility**: 10.x, 11.x
**Latest Version**: Check [releases page](https://www.drupal.org/project/langfuse/releases)
for current version

### Supporting Organizations

- [Dropsolid](https://www.drupal.org/dropsolid) — Founding and funding organization.
