<?php

declare(strict_types=1);

namespace Drupal\languagewire_translation_provider\api\Managers;

use Drupal\languagewire_translation_provider\api\Endpoints\General\Languages;
use Drupal\languagewire_translation_provider\api\Endpoints\General\MTLanguages;

/**
 * Language manager.
 */
class LanguageManager extends AbstractManager {

  /**
   * Get available languages.
   */
  public function getAvailableLanguages(): array {
    $languagesEndpoint = new Languages($this->settings);
    $languages = $languagesEndpoint->execute();

    if (!$languages || count($languages) === 0) {
      return [];
    }

    $orderedLanguages = [];
    foreach ($languages as $language) {
      $orderedLanguages[$language['languageCode']] = $language['languageName'];
    }

    asort($orderedLanguages);

    return $orderedLanguages;
  }

  public function getAvailableMTLanguages(): array {
    $languagesMTEndpoint = new MTLanguages($this->settings);
    $languagesMT = $languagesMTEndpoint->execute();

    if (!$languagesMT || count($languagesMT) === 0) {
      return [];
    }

    $orderedLanguagesMT = [];
    foreach ($languagesMT as $languageMT) {
      $orderedLanguagesMT[$languageMT['languageCode']] = $languageMT['languageName'];
    }

    asort($orderedLanguagesMT);

    return $orderedLanguagesMT;
  }
}
