<?php

namespace Drupal\languagewire_translation_provider\Client;

use Drupal\languagewire_translation_provider\Adapter\SystemInterface;
use Drupal\languagewire_translation_provider\api\Core\Settings;
use Drupal\languagewire_translation_provider\LanguageWireConnector;
use Drupal\languagewire_translation_provider\Settings\Endpoint;

/**
 * LanguageWire Client Settings.
 */
final class LanguageWireClientSettings implements ClientSettingsInterface {
  /**
   * Application name.
   */
  private const APPLICATION_NAME = 'drupal-connector';

  /**
   * System.
   *
   * @var \Drupal\languagewire_translation_provider\Adapter\SystemInterface
   */
  private SystemInterface $system;

  /**
   * Authorization token.
   *
   * @var string
   */
  private string $authorizationToken;

  /**
   * Constructs a new LanguageWireClientSettings object.
   *
   * @param string $authorizationToken
   *   Authorization token.
   * @param \Drupal\languagewire_translation_provider\Adapter\SystemInterface $system
   *   System.
   */
  public function __construct(string $authorizationToken, SystemInterface $system) {
    $this->authorizationToken = $authorizationToken;
    $this->system = $system;
  }

  /**
   * {@inheritdoc}
   */
  public function get(): Settings {
    $endpoint = new Endpoint($this->system->settings());

    return new Settings(
      $endpoint->get(),
      $this->authorizationToken,
      self::APPLICATION_NAME,
      $this->getConnectorVersion(),
      $this->getDrupalVersion(),
    );
  }

  /**
   * Get the connector version.
   */
  private function getConnectorVersion(): string {
    return $this->system->moduleVersion(LanguageWireConnector::MODULE_NAME) ?? 'unknown';
  }

  /**
   * Get the Drupal version.
   */
  private function getDrupalVersion(): string {
    return $this->system->version();
  }

}
