<?php

declare(strict_types=1);

namespace Drupal\languagewire_translation_provider\api\Models;

/**
 * Language model.
 */
class LanguageModel {
  public const AFRIKAANS = 'af';
  public const ARABIC_UAE = 'ar-AE';
  public const ARABIC_BAHRAIN = 'ar-BH';
  public const ARABIC_ALGERIA = 'ar-DZ';
  public const ARABIC_EGYPT = 'ar-EG';
  public const ARABIC_JORDAN = 'ar-JO';
  public const ARABIC_KUWAIT = 'ar-KW';
  public const ARABIC_LEBANON = 'ar-LB';
  public const ARABIC_LIBYA = 'ar-LY';
  public const ARABIC_MOROCCO = 'ar-MA';
  public const ARABIC_OMAN = 'ar-OM';
  public const ARABIC_QATAR = 'ar-QA';
  public const ARABIC_SAUDI_ARABIA = 'ar-SA';
  public const ARABIC_SYRIA = 'ar-SY';
  public const ARABIC_TUNISIA = 'ar-TN';
  public const ARABIC_YEMEN = 'ar-YE';
  public const AZERBAIJANI_LATIN = 'az-Latn';
  public const BELARUSIAN = 'be';
  public const BULGARIAN = 'bg';
  public const CATALAN = 'ca';
  public const CZECH = 'cs';
  public const DANISH = 'da';
  public const GERMAN_AUSTRIA = 'de-AT';
  public const GERMAN_SWITZERLAND = 'de-CH';
  public const GERMAN_GERMANY = 'de-DE';
  public const GERMAN_LIECHTENSTEIN = 'de-LI';
  public const GERMAN_LUXEMBOURG = 'de-LU';
  public const GREEK = 'el';
  public const ENGLISH_AUSTRALIA = 'en-AU';
  public const ENGLISH_BELIZE = 'en-BZ';
  public const ENGLISH_CANADA = 'en-CA';
  public const ENGLISH_UNITED_KINGDOM = 'en-GB';
  public const ENGLISH_IRELAND = 'en-IE';
  public const ENGLISH_JAMAICA = 'en-JM';
  public const ENGLISH_NEW_ZEALAND = 'en-NZ';
  public const ENGLISH_TRINIDAD_TOBAGO = 'en-TT';
  public const ENGLISH_UNITED_STATES = 'en-US';
  public const ENGLISH_SOUTH_AFRICA = 'en-ZA';
  public const SPANISH_ARGENTINA = 'es-AR';
  public const SPANISH_BOLIVIA = 'es-BO';
  public const SPANISH_CHILE = 'es-CL';
  public const SPANISH_COLOMBIA = 'es-CO';
  public const SPANISH_COSTA_RICA = 'es-CR';
  public const SPANISH_DOMINICAN_REPUBLIC = 'es-DO';
  public const SPANISH_ECUADOR = 'es-EC';
  public const SPANISH_SPAIN = 'es-ES';
  public const SPANISH_GUATEMALA = 'es-GT';
  public const SPANISH_HONDURAS = 'es-HN';
  public const SPANISH_MEXICO = 'es-MX';
  public const SPANISH_NICARAGUA = 'es-NI';
  public const SPANISH_PANAMA = 'es-PA';
  public const SPANISH_PERU = 'es-PE';
  public const SPANISH_PUERTO_RICO = 'es-PR';
  public const SPANISH_PARAGUAY = 'es-PY';
  public const SPANISH_EL_SALVADOR = 'es-SV';
  public const SPANISH_URUGUAY = 'es-UY';
  public const SPANISH_BOLIVARIAN_REPUBLIC_OF_VENEZUELA = 'es-VE';
  public const ESTONIAN = 'et';
  public const BASQUE = 'eu';
  public const PERSIAN = 'fa';
  public const FINNISH = 'fi';
  public const FRENCH_BELGIUM = 'fr-BE';
  public const FRENCH_CANADA = 'fr-CA';
  public const FRENCH_SWITZERLAND = 'fr-CH';
  public const FRENCH_FRANCE = 'fr-FR';
  public const FRENCH_LUXEMBOURG = 'fr-LU';
  public const IRISH = 'ga';
  public const SCOTTISH_GAELIC = 'gd';
  public const HEBREW = 'he';
  public const HINDI = 'hi';
  public const CROATIAN = 'hr';
  public const HUNGARIAN = 'hu';
  public const ARMENIAN = 'hy';
  public const INDONESIAN = 'id';
  public const ICELANDIC = 'is';
  public const ITALIAN_SWITZERLAND = 'it-CH';
  public const ITALIAN_ITALY = 'it-IT';
  public const JAPANESE = 'ja';
  public const GEORGIAN = 'ka';
  public const KAZAKH = 'kk';
  public const KOREAN = 'ko';
  public const LITHUANIAN = 'lt';
  public const LATVIAN = 'lv';
  public const MACEDONIAN = 'mk';
  public const MALAY = 'ms';
  public const MALTESE = 'mt';
  public const NORWEGIAN_BOKMAL = 'nb';
  public const DUTCH_BELGIUM = 'nl-BE';
  public const DUTCH_NETHERLANDS = 'nl-NL';
  public const NORWEGIAN_NYNORSK = 'nn';
  public const POLISH = 'pl';
  public const PORTUGUESE_BRAZIL = 'pt-BR';
  public const PORTUGUESE_PORTUGAL = 'pt-PT';
  public const ROMANIAN = 'ro';
  public const RUSSIAN = 'ru';
  public const SLOVAK = 'sk';
  public const SLOVENIAN = 'sl';
  public const ALBANIAN = 'sq';
  public const SERBIAN_CYRILLIC = 'sr-Cyrl';
  public const SERBIAN_LATIN = 'sr-Latn';
  public const SWEDISH_FINLAND = 'sv-FI';
  public const SWEDISH_SWEDEN = 'sv-SE';
  public const THAI = 'th';
  public const TURKISH = 'tr';
  public const UKRAINIAN = 'uk';
  public const URDU = 'ur';
  public const VIETNAMESE = 'vi';
  public const CHINESE_SIMPLIFIED_CHINA = 'zh-CN';
  public const CHINESE_TRADITIONAL_HONG_KONG_SAR = 'zh-HK';
  public const CHINESE_SIMPLIFIED_SINGAPORE = 'zh-SG';
  public const CHINESE_TRADITIONAL_TAIWAN = 'zh-TW';

  /**
   * Mapping of language code to English name of a language.
   *
   * @var array
   */
  public static array $englishLabels = [
    self::AFRIKAANS => 'Afrikaans',
    self::ARABIC_UAE => 'Arabic (U.A.E.)',
    self::ARABIC_BAHRAIN => 'Arabic (Bahrain)',
    self::ARABIC_ALGERIA => 'Arabic (Algeria)',
    self::ARABIC_EGYPT => 'Arabic (Egypt)',
    self::ARABIC_JORDAN => 'Arabic (Jordan)',
    self::ARABIC_KUWAIT => 'Arabic (Kuwait)',
    self::ARABIC_LEBANON => 'Arabic (Lebanon)',
    self::ARABIC_LIBYA => 'Arabic (Libya)',
    self::ARABIC_MOROCCO => 'Arabic (Morocco)',
    self::ARABIC_OMAN => 'Arabic (Oman)',
    self::ARABIC_QATAR => 'Arabic (Qatar)',
    self::ARABIC_SAUDI_ARABIA => 'Arabic (Saudi Arabia)',
    self::ARABIC_SYRIA => 'Arabic (Syria)',
    self::ARABIC_TUNISIA => 'Arabic (Tunisia)',
    self::ARABIC_YEMEN => 'Arabic (Yemen)',
    self::AZERBAIJANI_LATIN => 'Azerbaijani (Latin)',
    self::BELARUSIAN => 'Belarusian',
    self::BULGARIAN => 'Bulgarian',
    self::CATALAN => 'Catalan',
    self::CZECH => 'Czech',
    self::DANISH => 'Danish',
    self::GERMAN_AUSTRIA => 'German (Austria)',
    self::GERMAN_SWITZERLAND => 'German (Switzerland)',
    self::GERMAN_GERMANY => 'German (Germany)',
    self::GERMAN_LIECHTENSTEIN => 'German (Liechtenstein)',
    self::GERMAN_LUXEMBOURG => 'German (Luxembourg)',
    self::GREEK => 'Greek',
    self::ENGLISH_AUSTRALIA => 'English (Australia)',
    self::ENGLISH_BELIZE => 'English (Belize)',
    self::ENGLISH_CANADA => 'English (Canada)',
    self::ENGLISH_UNITED_KINGDOM => 'English (United Kingdom)',
    self::ENGLISH_IRELAND => 'English (Ireland)',
    self::ENGLISH_JAMAICA => 'English (Jamaica)',
    self::ENGLISH_NEW_ZEALAND => 'English (New Zealand)',
    self::ENGLISH_TRINIDAD_TOBAGO => 'English (Trinidad and Tobago)',
    self::ENGLISH_UNITED_STATES => 'English (United States)',
    self::ENGLISH_SOUTH_AFRICA => 'English (South Africa)',
    self::SPANISH_ARGENTINA => 'Spanish (Argentina)',
    self::SPANISH_BOLIVIA => 'Spanish (Bolivia)',
    self::SPANISH_CHILE => 'Spanish (Chile)',
    self::SPANISH_COLOMBIA => 'Spanish (Colombia)',
    self::SPANISH_COSTA_RICA => 'Spanish (Costa Rica)',
    self::SPANISH_DOMINICAN_REPUBLIC => 'Spanish (Dominican Republic)',
    self::SPANISH_ECUADOR => 'Spanish (Ecuador)',
    self::SPANISH_SPAIN => 'Spanish (Spain)',
    self::SPANISH_GUATEMALA => 'Spanish (Guatemala)',
    self::SPANISH_HONDURAS => 'Spanish (Honduras)',
    self::SPANISH_MEXICO => 'Spanish (Mexico)',
    self::SPANISH_NICARAGUA => 'Spanish (Nicaragua)',
    self::SPANISH_PANAMA => 'Spanish (Panama)',
    self::SPANISH_PERU => 'Spanish (Peru)',
    self::SPANISH_PUERTO_RICO => 'Spanish (Puerto Rico)',
    self::SPANISH_PARAGUAY => 'Spanish (Paraguay)',
    self::SPANISH_EL_SALVADOR => 'Spanish (El Salvador)',
    self::SPANISH_URUGUAY => 'Spanish (Uruguay)',
    self::SPANISH_BOLIVARIAN_REPUBLIC_OF_VENEZUELA => 'Spanish (Bolivarian Republic of Venezuela)',
    self::ESTONIAN => 'Estonian',
    self::BASQUE => 'Basque',
    self::PERSIAN => 'Persian',
    self::FINNISH => 'Finnish',
    self::FRENCH_BELGIUM => 'French (Belgium)',
    self::FRENCH_CANADA => 'French (Canada)',
    self::FRENCH_SWITZERLAND => 'French (Switzerland)',
    self::FRENCH_FRANCE => 'French (France)',
    self::FRENCH_LUXEMBOURG => 'French (Luxembourg)',
    self::IRISH => 'Irish',
    self::SCOTTISH_GAELIC => 'Scottish Gaelic',
    self::HEBREW => 'Hebrew',
    self::HINDI => 'Hindi',
    self::CROATIAN => 'Croatian',
    self::HUNGARIAN => 'Hungarian',
    self::ARMENIAN => 'Armenian',
    self::INDONESIAN => 'Indonesian',
    self::ICELANDIC => 'Icelandic',
    self::ITALIAN_SWITZERLAND => 'Italian (Switzerland)',
    self::ITALIAN_ITALY => 'Italian (Italy)',
    self::JAPANESE => 'Japanese',
    self::GEORGIAN => 'Georgian',
    self::KAZAKH => 'Kazakh',
    self::KOREAN => 'Korean',
    self::LITHUANIAN => 'Lithuanian',
    self::LATVIAN => 'Latvian',
    self::MACEDONIAN => 'Macedonian (Former Yugoslav Republic of Macedonia)',
    self::MALAY => 'Malay',
    self::MALTESE => 'Maltese',
    self::NORWEGIAN_BOKMAL => 'Norwegian (Bokmål)',
    self::DUTCH_BELGIUM => 'Dutch (Belgium)',
    self::DUTCH_NETHERLANDS => 'Dutch (Netherlands)',
    self::NORWEGIAN_NYNORSK => 'Norwegian (Nynorsk)',
    self::POLISH => 'Polish',
    self::PORTUGUESE_BRAZIL => 'Portuguese (Brazil)',
    self::PORTUGUESE_PORTUGAL => 'Portuguese (Portugal)',
    self::ROMANIAN => 'Romanian',
    self::RUSSIAN => 'Russian',
    self::SLOVAK => 'Slovak',
    self::SLOVENIAN => 'Slovenian',
    self::ALBANIAN => 'Albanian',
    self::SERBIAN_CYRILLIC => 'Serbian (Cyrillic)',
    self::SERBIAN_LATIN => 'Serbian (Latin)',
    self::SWEDISH_FINLAND => 'Swedish (Finland)',
    self::SWEDISH_SWEDEN => 'Swedish (Sweden)',
    self::THAI => 'Thai',
    self::TURKISH => 'Turkish',
    self::UKRAINIAN => 'Ukrainian',
    self::URDU => 'Urdu',
    self::VIETNAMESE => 'Vietnamese',
    self::CHINESE_SIMPLIFIED_CHINA => 'Chinese (Simplified, China)',
    self::CHINESE_TRADITIONAL_HONG_KONG_SAR => 'Chinese (Traditional, Hong Kong SAR)',
    self::CHINESE_SIMPLIFIED_SINGAPORE => 'Chinese (Simplified, Singapore)',
    self::CHINESE_TRADITIONAL_TAIWAN => 'Chinese (Traditional, Taiwan)',
  ];

}
