(function ($, Drupal, once) {
  Drupal.behaviors.copyAccountId = {
    attach: function (context, settings) {
      once('copy-account-number', '.copy-account-number', context).forEach(function(element) {
        var $span = $(element);
        var $tooltip = $('<span class="copy-tooltip"></span>').text(Drupal.t('Click to copy'));
        var $icon = $('<span class="copy-icon"></span>').html('<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path></svg>');
        
        $span.wrap('<div class="account-number-wrapper"></div>');
        $span.after($icon);
        $span.append($tooltip);

        function copyToClipboard(e) {
          e.preventDefault();
          var accountId = $span.data('account-number');
          navigator.clipboard.writeText(accountId).then(function() {
            $tooltip.text(Drupal.t('Copied!'));
            setTimeout(function() {
              $tooltip.text(Drupal.t('Click to copy'));
            }, 2000);
          }, function(err) {
            console.error('Could not copy text: ', err);
            $tooltip.text(Drupal.t('Failed to copy'));
            setTimeout(function() {
              $tooltip.text(Drupal.t('Click to copy'));
            }, 2000);
          });
        }

        $span.on('click', copyToClipboard);
        $icon.on('click', copyToClipboard);

        $span.add($icon).on('mouseenter', function() {
          $tooltip.addClass('show');
        });

        $span.add($icon).on('mouseleave', function() {
          $tooltip.removeClass('show');
        });
      });
    }
  };
})(jQuery, Drupal, once);