(function ($, Drupal) {
  Drupal.behaviors.lapostaSubscribe = {
    attach: function (context, settings) {
      once("lapostaSubscribe", ".laposta-subscribe-form", context).forEach(
        function (element) {
          var $form = $(element);
          var $submitButton = $form.find('input[type="submit"]');
          var $formWrapper = $form.closest('.laposta-subscribe');
          var $throbberWrapper = $formWrapper.find('.throbber-wrapper');
          var $messageWrapper = $formWrapper.find('.message-wrapper');
          var $successMessage = $messageWrapper.find('.message--success');
          var $errorMessage = $messageWrapper.find('.message--error');

          // Fallback: If throbber-wrapper doesn't exist, create it before the submit button
          if ($throbberWrapper.length === 0) {
            $throbberWrapper = $('<div class="throbber-wrapper"></div>');
            $submitButton.after($throbberWrapper);
          }

          // Fallback: If message-wrapper doesn't exist, create it after the form
          if ($messageWrapper.length === 0) {
            $messageWrapper = $('<div class="message-wrapper"></div>');
            $form.after($messageWrapper);
          }

          // Fallback: If success message container doesn't exist, create it
          if ($successMessage.length === 0) {
            $successMessage = $('<div class="message message--success"></div>');
            $messageWrapper.append($successMessage);
          }

          // Fallback: If error message container doesn't exist, create it
          if ($errorMessage.length === 0) {
            $errorMessage = $('<div class="message message--error"></div>');
            $messageWrapper.append($errorMessage);
          }

          $form.submit(function (e) {
            e.preventDefault();

            // Clear and hide previous messages
            $successMessage.empty().hide();
            $errorMessage.empty().hide();

            // Serialize all form data
            var formData = $form.serializeArray();
            var dataObject = {};
            $.each(formData, function (i, field) {
              if (field.name.endsWith('[]')) {
                var fieldName = field.name.slice(0, -2);
                if (!dataObject[fieldName]) {
                  dataObject[fieldName] = [];
                }
                dataObject[fieldName].push(field.value);
              } else {
                dataObject[field.name] = field.value;
              }
            });

            // Add throbber
            $submitButton.prop("disabled", true);
            $throbberWrapper.html('<span class="ajax-progress ajax-progress-throbber"><span class="throbber">&nbsp;</span><span class="message">' + Drupal.t("Subscribing...") + "</span></span>");

            $.ajax({
              url: "/laposta-subscribe",
              method: "POST",
              data: dataObject,
              success: function (response) {
                $successMessage.html(response.message).show();
                scheduleMessageHide($successMessage);
              },
              error: function (xhr, status, error) {
                var errorMsg = xhr.responseJSON?.error || Drupal.t("We couldn't process your request at this time. Please try again later.");
                $errorMessage.html(errorMsg).show();
                scheduleMessageHide($errorMessage);
              },
              complete: function () {
                // Remove throbber and re-enable submit button
                $submitButton.prop("disabled", false);
                $throbberWrapper.empty();
              },
            });
          });

          // Function to schedule message hiding
          function scheduleMessageHide($message) {
            setTimeout(function () {
              $message.fadeOut(400);
            }, 5000); // 5000 milliseconds = 5 seconds
          }

          // Hide any existing messages
          $('.message--success, .message--error', $messageWrapper).hide();
        }
      );
    },
  };
})(jQuery, Drupal);