<?php

namespace Drupal\laposta_subscribe\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Drupal\laposta_subscribe\Service\LapostaSubscribeApiService;
use Symfony\Component\DependencyInjection\ContainerInterface;

class LapostaSubscribeHelpController extends ControllerBase
{
  protected $lapostaSubscribeApiService;

  public function __construct(LapostaSubscribeApiService $laposta_subscribe_api_service)
  {
    $this->lapostaSubscribeApiService = $laposta_subscribe_api_service;
  }

  public static function create(ContainerInterface $container)
  {
    return new static(
      $container->get('laposta_subscribe.api_service')
    );
  }

  public function help()
  {
    $help_email = 'helpdesk@laposta.nl';
    $author_email = 'fred@miix.dev';

    // Get API info
    $api_info = $this->lapostaSubscribeApiService->getApiInfo();

    $build = [
      '#theme' => 'laposta_subscribe_help',
      '#content' => [
        'general_setup' => [
          'title' => $this->t('General Setup'),
          'items' => [
            $this->t('Enter your Laposta API key in the API Key Settings.'),
            $this->t('Select a list and fetch available fields in the List and Fields Settings.'),
            $this->t('Configure form display settings in the Form Settings.'),
          ],
        ],
        'field_configuration' => [
          'title' => $this->t('Field Configuration'),
          'items' => [
            $this->t('Enable or disable fields as needed.'),
            $this->t('Rearrange fields by dragging them in the field table.'),
            $this->t('Single select fields can be displayed as dropdown or radio buttons (Laposta setting).'),
          ],
        ],
        'form_customization' => [
          'title' => $this->t('Form Customization'),
          'items' => [
            $this->t('Override the list name for display purposes.'),
            $this->t('Show or hide list remarks.'),
            $this->t('Customize the submit button text.'),
          ],
        ],
        'preview' => [
          'title' => $this->t('Preview'),
          'content' => $this->t('Use the Preview tab to preview your form and ensure it\'s working correctly.'),
        ],
        'adding_form' => [
          'title' => $this->t('Adding the Subscription Form to Your Website'),
          'items' => [
            $this->t('Go to the Structure > Block layout page (@url).', ['@url' => Url::fromRoute('block.admin_display')->toString()]),
            $this->t('Click "Place block" in the region where you want the form to appear.'),
            $this->t('Find "Laposta Subscribe Form" in the list and click "Place block".'),
            $this->t('Configure the block settings as needed (title, visibility rules, etc.).'),
            $this->t('Click "Save block".'),
            $this->t('The subscription form will now appear in the selected region of your website.'),
          ],
        ],
        'troubleshooting' => [
          'title' => $this->t('Troubleshooting'),
          'items' => [
            $this->t('Clear cache after making configuration changes.'),
            $this->t('Check Drupal logs for any error messages.'),
            $this->t('Ensure your Laposta API key is valid and has necessary permissions.'),
          ],
        ],
        'api_status' => [
          'title' => $this->t('API Connection Status'),
          'status' => $api_info['status'],
          'message' => $api_info['message'],
          'account_name' => $api_info['account_name'] ?? $this->t('Not available'),
          'account_number' => $api_info['account_number'] ?? $this->t('Not available'),
        ],
        'further_assistance' => [
          'title' => $this->t('Need Further Assistance?'),
          'content' => $this->t('If you need additional help or have any questions, please don\'t hesitate to contact the Laposta support team at:'),
          'email' => $help_email,
        ],
        'about_author' => [
          'title' => $this->t('About the Author'),
          'content' => $this->t('This module was created by Fred Klopper. For module-specific inquiries or support, you can contact the author at:'),
          'email' => $author_email,
        ],
      ],
    ];

    $build['#attached']['library'][] = 'laposta_subscribe/admin_styles';
    $build['#attached']['library'][] = 'laposta_subscribe/copy_account_number';

    return $build;
  }
}