<?php

namespace Drupal\laposta_subscribe\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\laposta_subscribe\Service\LapostaSubscribeLogger;

class LapostaSubscribeLogController extends ControllerBase {

  protected $logger;

  public function __construct(LapostaSubscribeLogger $logger) {
    $this->logger = $logger;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('laposta_subscribe.logger')
    );
  }

  public function content() {
    $subscriptions = $this->logger->getRecentSubscriptions();

    return [
      '#theme' => 'laposta_subscription_log',
      '#subscriptions' => $subscriptions,
      '#explanation' => $this->t('A maximum of 20 items are kept (the oldest are automatically deleted).<br>* IP addresses are anonymised.'),
    ];
  }
}