<?php

namespace Drupal\laposta_subscribe\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class LapostaSubscribeFormSettingsForm extends ConfigFormBase
{
  protected function getEditableConfigNames()
  {
    return ['laposta_subscribe.settings'];
  }

  public function getFormId()
  {
    return 'laposta_subscribe_form_settings_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $form['#attached']['library'][] = 'laposta_subscribe/admin_styles';

    $config = $this->config('laposta_subscribe.settings');
    $api_key = $config->get('api_key');
    $enabled_fields = $config->get('enabled_fields');
    $list_id = $config->get('list_id');

    if (empty($api_key)) {
      $form['message'] = [
        '#markup' => $this->t('Please set your API key first.'),
      ];
      return $form;
    }

    if (empty($list_id) || empty($enabled_fields)) {
      $form['message'] = [
        '#markup' => $this->t('Please select a list and enable some fields.'),
      ];
      return $form;
    }

    $form['list_name_override'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Title'),
      '#description' => $this->t('Leave empty to use the list name.'),
      '#default_value' => $config->get('list_name_override') ?: '',
    ];

    $form['show_list_remarks'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show list remarks'),
      '#description' => $this->t('If checked, the list remarks will be displayed after the list name.'),
      '#default_value' => $config->get('show_list_remarks') ?: FALSE,
    ];

    $form['submit_button_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Submit Button Text'),
      '#default_value' => $config->get('submit_button_text') ?: $this->t('Subscribe'),
      '#required' => TRUE,
    ];

    $form['privacy_policy_text'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Privacy Policy Text'),
      '#description' => $this->t('Enter the text to display at the end of the form. You can use basic HTML for formatting and links.'),
      '#default_value' => $config->get('privacy_policy_text')['value'] ?? '',
      '#format' => $config->get('privacy_policy_text')['format'] ?? 'basic_html',
      '#rows' => 3,
      '#editor' => [
        'rows' => 3,
        'maxrows' => 5,
      ],
      '#wrapper_attributes' => [
        'class' => ['privacy-policy-text-wrapper'],
      ],
    ];

    $form['#after_build'][] = [$this, 'alterTextFormatElement'];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    $this->config('laposta_subscribe.settings')
      ->set('list_name_override', $form_state->getValue('list_name_override'))
      ->set('submit_button_text', $form_state->getValue('submit_button_text'))
      ->set('show_list_remarks', $form_state->getValue('show_list_remarks'))
      ->set('privacy_policy_text', $form_state->getValue('privacy_policy_text'))
      ->save();

    parent::submitForm($form, $form_state);
  }

  /**
   * Alter the text format element to hide format selection but keep CKEditor.
   */
  public function alterTextFormatElement(array $form, FormStateInterface $form_state)
  {
    if (isset($form['privacy_policy_text']['format'])) {
      // Hide the format selector but keep it in the DOM for CKEditor initialization
      $form['privacy_policy_text']['format']['#attributes']['style'] = 'display: none;';
      $form['privacy_policy_text']['format']['format']['#access'] = FALSE;
      $form['privacy_policy_text']['format']['help']['#access'] = FALSE;
      $form['privacy_policy_text']['format']['guidelines']['#access'] = FALSE;
    }
    return $form;
  }
}