<?php

namespace Drupal\laposta_webform\Element;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element\Select;

/**
 * Provides a form element for selecting Laposta lists.
 *
 * @FormElement("laposta_list_select")
 */
class LapostaListSelect extends Select {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    $info = parent::getInfo();
    $class = get_class($this);
    $info['#process'][] = [$class, 'processLapostaListSelect'];
    $info['#laposta_empty_option'] = '';
    return $info;
  }

  /**
   * Processes a Laposta list select element.
   *
   * @param array $element
   *   The form element.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array $complete_form
   *   The complete form array.
   *
   * @return array
   *   The processed element.
   */
  public static function processLapostaListSelect(array &$element, FormStateInterface $form_state, array &$complete_form) {
    // Get the Laposta API service.
    /** @var \Drupal\laposta_webform\Service\LapostaApi $api */
    $api = \Drupal::service('laposta_webform.api');

    // Fetch lists from Laposta.
    $lists = $api->getLists();

    // Build options.
    $options = [];
    if (!empty($element['#laposta_empty_option'])) {
      $options[''] = $element['#laposta_empty_option'];
    }
    $options += $lists;

    $element['#options'] = $options;

    return $element;
  }

}
