# Laposta Webform

A Drupal module that integrates [Webform](https://www.drupal.org/project/webform) with [Laposta](https://www.laposta.nl/) mailing lists.

## Features

### Webform Handler
Add a Laposta handler to any webform to subscribe visitors to your mailing lists.

- **Fixed list subscription**: Select a specific Laposta list to subscribe all form submissions to
- **Dynamic list selection**: Let visitors choose which list(s) to subscribe to using a special Laposta list select element
- **Multiple list support**: Subscribe visitors to multiple lists at once
- **Opt-in field support**: Configure a checkbox field for GDPR-compliant opt-in before subscribing
- **Field mapping**: Map webform fields to Laposta custom fields

### Field Types
Supports all Laposta field types:
- Text
- Numeric
- Date
- Single select
- Multiple select

### Laposta List Elements
Two custom webform elements that automatically populate with your Laposta mailing lists:

#### Laposta List Select
- Dropdown select element
- Supports single or multiple selection
- Configurable empty option label for single select

#### Laposta List Checkboxes
- Checkbox list element
- Ideal for multiple list selection
- More user-friendly when selecting multiple lists

Both elements:
- Fetch lists directly from the Laposta API
- **List filtering**: Optionally restrict which lists visitors can see and subscribe to
- Show connection status in the element settings

### Smart Field Mapping

#### Fixed List Mode
- Manual field mapping via dropdown selects
- Shows required Laposta fields with asterisk (*)
- Auto-suggests mappings based on matching field names
- Warns about unmapped required fields
- Automatically marks webform fields as required when mapped to required Laposta fields

#### Dynamic List Mode
- Automatic field mapping by matching field names/tags (case-insensitive)
- No manual configuration needed
- Validates required fields at submission time for each selected list
- Fetches field requirements from Laposta API before subscribing

### Required Field Validation
- Validates required Laposta fields before attempting subscription
- Shows user-friendly error messages for missing required fields
- Prevents failed API calls due to missing data

## Installation

1. Install the module in your Drupal modules directory
2. Enable the module: `drush en laposta_webform`
3. Configure your API key at `/admin/config/services/laposta-webform`

## Configuration

### API Key
1. Go to **Configuration > Web services > Laposta Webform**
2. Enter your Laposta API key
3. Click **Save configuration**

### Adding to a Webform

1. Edit your webform
2. Go to **Settings > Emails / Handlers**
3. Click **Add handler** and select **Laposta**
4. Configure the handler:
   - **List Settings**: Choose a fixed list or a list selection field
   - **Email Field**: Select the webform field containing the email address
   - **Opt-in Field**: Optionally select a checkbox for opt-in consent
   - **Field Mapping**: Map webform fields to Laposta custom fields (fixed list mode only)

### Using the Laposta List Elements

1. Edit your webform
2. Add a new element:
   - **Laposta list select** - for dropdown selection (single or multiple)
   - **Laposta list checkboxes** - for checkbox selection (always multiple)
3. Configure the element:
   - **Show only these lists**: Select which lists visitors can subscribe to (leave empty to show all)
   - For select: Enable **Allow multiple selections** if visitors should be able to select multiple lists
   - For select: Set an **Empty option label** (e.g., "- Select a list -")
4. In the Laposta handler, select this element as the **List Selection Field**

## Requirements

- Drupal 10 or 11
- Webform module
- Laposta account with API key

## Author

This module was created to provide a flexible integration between Drupal Webform and Laposta mailing lists.
