<?php

/**
 * @file
 * Contains \Drupal\last_login\Plugin\Block\LastLogin.
 */
namespace Drupal\last_login\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides 'LastLogin' block.
 *
 * @Block(
 *   id = "last_login",
 *   title = "Last Login Time",
 *   description = "Display the last login time of current user",
 *   admin_label = @Translation("Last Login Time"),
 *   category = @Translation("Last Login"),
 * )
 */
class LastLogin extends BlockBase {
  /**
   * {@inheritDoc}
   */
  public function build() {
    if(\Drupal::currentUser()->id() > 0) {
      $output = isset($_SESSION['user_last_login']) ? $_SESSION['user_last_login'] : '';
    }
    else {
      $output = '';
    }
    return array(
      '#markup' => $output,
      '#cache' => array(
        'max-age' => 0,
      ),
    );
  }
}
