<?php

namespace Drupal\lawwwing\Form;

use Drupal\Core\Cache\CacheTagsInvalidatorInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure lawwwing settings for this site.
 */
class LawwwingAdminSettingsForm extends ConfigFormBase {

  /**
   * The cache tags invalidator service.
   *
   * @var \Drupal\Core\Cache\CacheTagsInvalidatorInterface
   */
  protected $cacheTagsInvalidator;

  /**
   * {@inheritdoc}
   */
  public function __construct(ConfigFactoryInterface $config_factory, TypedConfigManagerInterface $typedConfigManager, CacheTagsInvalidatorInterface $cache_tags_invalidator) {
    parent::__construct($config_factory, $typedConfigManager);

    $this->cacheTagsInvalidator = $cache_tags_invalidator;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('config.typed'),
      $container->get('cache_tags.invalidator'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'lawwwing_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['lawwwing.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('lawwwing.settings');

    $form['enabled'] = [
      '#default_value' => $config->get('enabled'),
      '#description' => $this->t('Check this box to enable Lawwwing on your site.'),
      '#title' => $this->t('Lawwwing Enabled'),
      '#type' => 'checkbox',
    ];

    $form['plugin_id'] = [
      '#default_value' => $config->get('plugin_id'),
      '#description' => $this->t('Enter your Lawwwing plugin unique identifier (format: XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX). You can find this in your Lawwwing account.'),
      '#maxlength' => 50,
      '#required' => TRUE,
      '#title' => $this->t('Lawwwing Plugin ID'),
      '#type' => 'textfield',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->cacheTagsInvalidator->invalidateTags(['library_info']);

    $config = $this->config('lawwwing.settings');
    $config
      ->set('plugin_id', $form_state->getValue('plugin_id'))
      ->set('enabled', $form_state->getValue('enabled'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
