# Lawwwing

The Lawwwing module for Drupal simplifies the integration of the Lawwwing cookie script into your website. It automatically adds the script to the `<head>` section of your site by configuring a few settings, including the Lawwwing Script ID and optional access controls for private Sections -> admin theme or specific user roles. This module provides a user-friendly way to manage the Lawwwing service within your Drupal site.

## Requirements

- Drupal 10.0 or higher
- PHP 8.1 or greater
- A valid Lawwwing Script ID provided by the [Lawwwing service](https://www.lawwwing.com)

## Installation

1. Download the module via Composer:
   ```bash
   composer require drupal/lawwwing
   ```
2. Enable the module using Drush:
   ```bash
   drush en lawwwing -y
   ```
3. Configure the module settings by navigating to **Admin > Configuration > Web Services > Lawwwing Settings**.

## Configuration

After enabling the module, configure it to integrate the Lawwwing script:

1. Go to **Admin > Configuration > Web Services > Lawwwing Settings**.
2. Enter the **Lawwwing Script ID** provided by the Lawwwing service.
3. (Optional) Enable the **Private Section** option to restrict the script to private areas of your site.
4. (Optional) Specify **Permitted Roles** to limit which user roles can trigger the script insertion.
5. Save the configuration.

## Usage

Once configured, the Lawwwing module automatically inserts the Lawwwing cookie script into the `<head>` section of your website. No additional steps are required to enable the script. To verify it’s working:

1. Check the page source of your site to confirm the Lawwwing script is present in the `<head>` section.
2. Ensure the script functions as expected based on your Lawwwing service setup.

## Troubleshooting

- **Script not appearing in `<head>`:** Verify that the Lawwwing Script ID is correctly entered in the configuration settings.
- **Script not loading in Private Sections -> admin theme:** Ensure the "Private Section" option is enabled if you want the script to load in restricted areas.
- **Role-Based issues:** Confirm that the appropriate user roles are selected in the configuration if the script is restricted to specific roles.
- **General issues:** Ensure Drupal’s cache is cleared after enabling or configuring the module (`drush cache:rebuild`).
