<?php

namespace Drupal\Tests\lawwwing\Functional;

use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;

/**
 * Checks the form settings save.
 */
#[Group('lawwing')]
class LawwwingSettingsTest extends BrowserTestBase {

  const UUID = '11111111-1111-4111-8111-111111111111';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['lawwwing'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * An admin user.
   *
   * @var \Drupal\user\UserInterface
   */
  private $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer lawwwing settings',
    ]);
  }

  /**
   * Check that an user without permissions cannot access the config page.
   */
  public function testAccessDeniedForNormalUser() {
    $this->drupalGet('/admin/config/lawwwing');
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Check that an user with permissions can access the config page.
   */
  public function testAccessAllowedForAdminUser() {
    $this->drupalLogin($this->adminUser);

    $this->drupalGet('/admin/config/lawwwing');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Check that the configuration is correctly saved.
   */
  public function testSettingsSave() {
    $this->drupalLogin($this->adminUser);

    $edit = [
      'script_id' => static::UUID,
      'active_in_admin' => TRUE,
      'allowed_roles[authenticated]' => 'authenticated',
    ];

    $this->drupalGet('/admin/config/lawwwing');
    $this->submitForm($edit, 'Save configuration');

    $this->assertSession()->pageTextContains('The configuration options have been saved.');

    $config = $this->config('lawwwing.settings');
    $this->assertEquals(static::UUID, $config->get('script_id'));
  }

}
