<?php

namespace Drupal\Tests\lawwwing\Functional;

use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;

/**
 * Checks that the script is generated correctly.
 */
#[Group('lawwing')]
class LawwwingScriptTest extends BrowserTestBase {

  const UUID = '11111111-1111-4111-8111-111111111111';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['lawwwing'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Checks that the script is added to the HTML head.
   */
  public function testScriptIsAddedToHead() {
    $this->drupalGet('/');
    $this->assertSession()->responseNotContains(
      '<script src="https://cdn.lawwwing.com/widgets/current/' . static::UUID . '/cookie-widget.min.js',
    );

    $this->config('lawwwing.settings')->set('script_id', static::UUID)->save();

    $this->drupalGet('/');
    $this->assertSession()->responseContains(
      '<script src="https://cdn.lawwwing.com/widgets/current/' . static::UUID . '/cookie-widget.min.js',
    );
  }

  /**
   * Checks that the script is added to the HTML head in admin pages.
   */
  public function testScriptIsAddedToHeadInAdminPages() {
    $admin_user = $this->drupalCreateUser(admin: TRUE);
    $this->drupalLogin($admin_user);

    $this->drupalGet('/admin');
    $this->assertSession()->responseNotContains(
      '<script src="https://cdn.lawwwing.com/widgets/current/' . static::UUID . '/cookie-widget.min.js',
    );

    $this->config('lawwwing.settings')->set('active_in_admin', TRUE)
      ->set('script_id', static::UUID)
      ->save();

    $this->drupalGet('/admin');
    $this->assertSession()->responseContains(
      '<script src="https://cdn.lawwwing.com/widgets/current/' . static::UUID . '/cookie-widget.min.js',
    );

    $this->config('lawwwing.settings')->set('allowed_roles', [])->save();

    $this->drupalGet('/admin');
    $this->assertSession()->responseNotContains(
      '<script src="https://cdn.lawwwing.com/widgets/current/' . static::UUID . '/cookie-widget.min.js',
    );
  }

}
