async function fetchBlock(url, plugin, configuration, parent) {
  const response = await fetch(url, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({
      plugin_id: plugin,
      config: configuration,
    }),
  });
  try {
    if (!response.ok) {
      throw new Error(`HTTP ERROR! Status: ${response.status}`);
    }
    const result = await response.json();
    parent.innerHTML = result.content;
  } catch (error) {
    console.log(`Error fetching data: ${error.message}`);
  }
}

(function layoutBuilderAjaxBlocks(Drupal, once) {
  Drupal.behaviors.layout_builder_ajax_blocks = {
    attach: function attach(context, drupalSettings) {
      const settings = drupalSettings.layout_builder_ajax_blocks;
      once(
        'layoutBuilderAjaxBlocks',
        '.layout-builder-ajax-block-placeholder',
        context,
      ).forEach((block) => {
        const id = block.dataset.blockId;
        if (id && settings.blocks[id]) {
          const plugin = block.dataset.blockPluginId;
          if (plugin) {
            const parent = block.parentNode;

            let url = `layout_builder_ajax_blocks/load/${id}`;

            // Set context.
            if (settings.blocks[id].current_node) {
              url += `/node/${settings.blocks[id].current_node}`;
            } else if (settings.blocks[id].current_user) {
              url += `/user/${settings.blocks[id].current_user}`;
            } else if (settings.blocks[id].current_term) {
              url += `/taxonomy-term/${settings.blocks[id].current_term}`;
            }

            fetchBlock(Drupal.url(url), plugin, settings.blocks[id], parent);
          }
        }
      });
    },
  };
})(Drupal, once);
