<?php

namespace Drupal\layout_builder_ajax_blocks;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Layout Builder Ajax Blocks Service Provider class.
 */
class LayoutBuilderAjaxBlocksServiceProvider implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $container->getDefinition('layout_builder.render_block_component_subscriber')
      ->setClass('Drupal\layout_builder_ajax_blocks\EventSubscriber\BlockComponentRenderArraySubscriber')
      ->addArgument(new Reference('cache.default'))
      ->addArgument(new Reference('current_route_match'));
  }

}
