<?php

namespace Drupal\layout_builder_ipe\Traits;

/**
 * Helper trait for confirm dialogs.
 */
trait ConfirmDialogTrait {

  /**
   * Get the dialog options to be used for the confirm forms.
   *
   * @return array
   *   An array of dialog options.
   */
  private static function getDialogOptions($target = NULL) {
    return [
      'target' => $target ?? 'layout-builder-modal',
      'width' => 650,
      'height' => 'auto',
      'autoResize' => TRUE,
      'buttons' => [],
      'modal' => TRUE,
    ];
  }

}
