<?php

namespace Drupal\layout_builder_ipe\Traits;

use Drupal\Component\Plugin\Exception\ContextException;
use Drupal\Core\Form\ConfirmFormInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\layout_builder\Form\OverridesEntityForm;
use Drupal\layout_builder\Plugin\SectionStorage\DefaultsSectionStorage;
use Drupal\layout_builder\SectionStorageInterface;

/**
 * Helper trait for section storages in forms.
 */
trait SectionStorageTrait {

  /**
   * Get the section storage for the given form state.
   *
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return \Drupal\layout_builder\SectionStorageInterface|null
   *   The section storage.
   */
  public static function getSectionStorageFromFormState(FormStateInterface $form_state) {
    $form_object = $form_state->getFormObject();
    if ($form_object instanceof ConfirmFormInterface) {
      return reset($form_state->getBuildInfo()['args']);
    }
    elseif ($form_object instanceof OverridesEntityForm) {
      return $form_object->getSectionStorage();
    }
  }

  /**
   * Get the entity from the given section storage.
   *
   * @param \Drupal\layout_builder\SectionStorageInterface $section_storage
   *   The section storage.
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   The entity if found.
   */
  public function getEntityFromSectionStorage(SectionStorageInterface $section_storage) {
    if ($section_storage instanceof DefaultsSectionStorage) {
      return NULL;
    }
    try {
      $context = $section_storage->getContext('entity');
      return $context->hasContextValue() ? $context->getContextValue() : NULL;
    }
    catch (ContextException $e) {
      // Fail silently.
    }
    return NULL;
  }

}
