<?php

namespace Drupal\layout_builder_perms_block_operations_per_layout\Plugin\Derivative;

use Drupal\Core\Layout\LayoutPluginManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\layout_builder_perms\LayoutBuilderPermissionPluginDeriverBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines per content type LayoutBuilderPermission plugins.
 */
class LayoutLayoutBuilderPermissions extends LayoutBuilderPermissionPluginDeriverBase implements ContainerDeriverInterface {

  /**
   * The layout plugin manager.
   *
   * @var \Drupal\Core\Layout\LayoutPluginManagerInterface
   */
  protected $layoutPluginManager;

  /**
   * LayoutLayoutBuilderPermissions constructor.
   *
   * @param \Drupal\Core\Layout\LayoutPluginManagerInterface $layout_plugin_manager
   *   The layout plugin manager.
   */
  public function __construct(LayoutPluginManagerInterface $layout_plugin_manager) {
    $this->layoutPluginManager = $layout_plugin_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('plugin.manager.core.layout')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    // Per layout type permissions.
    foreach ($this->layoutPluginManager->getLayoutOptions() as $layout_group) {
      foreach ($layout_group as $layout_id => $layout_name) {
        if ($layout_name) {
          /** @var \Drupal\Core\StringTranslation\TranslatableMarkup $layout_name */
          foreach (['block_reorder', 'block_add', 'block_config', 'block_remove'] as $operation) {
            [$component, $action] = explode('_', $operation);
            $plugin_id = $layout_id . ':' . $operation;
            $this->derivatives[$plugin_id] = $base_plugin_definition;
            $this->derivatives[$plugin_id]['permission'] =
              $action . ' ' . $component . 's in ' . $layout_id . ' layouts';
            $layout_name = $layout_name instanceof TranslatableMarkup
              ? $layout_name->getUntranslatedString()
              : $layout_name;
            $this->derivatives[$plugin_id]['label'] =
              ucfirst($action) . ' ' . $component . 's in ' . $layout_name . ' layouts';
            $this->derivatives[$plugin_id]['description'] = '';
            $this->derivatives[$plugin_id]['operation'] = $operation;
            $this->derivatives[$plugin_id]['action'] = $action;
            $this->derivatives[$plugin_id]['component'] = $component;
            $this->derivatives[$plugin_id]['layout'] = $layout_id;
          }
        }
      }
    }
    return $this->derivatives;
  }

}
