<?php

namespace Drupal\layout_builder_perms_block_operations_per_layout\Plugin\LayoutBuilderPermission;

use Drupal\Component\Plugin\Exception\ContextException;
use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\Utility\Error;
use Drupal\layout_builder_perms\LayoutBuilderPermissionBase;

/**
 * Discovers per layout LayoutBuilderPermission plugins.
 *
 * @LayoutBuilderPermission(
 *   id = "layout",
 *   context_definitions = {
 *     "layout" = @ContextDefinition("layout_section", label = @Translation("Layout"), required = FALSE),
 *     "operation" = @ContextDefinition("string", label = @Translation("Operation"), required = TRUE)
 *   },
 *   deriver = "Drupal\layout_builder_perms_block_operations_per_layout\Plugin\Derivative\LayoutLayoutBuilderPermissions"
 * )
 */
class LayoutPermission extends LayoutBuilderPermissionBase {

  /**
   * {@inheritdoc}
   */
  public function applies(): bool {
    // Let the parent check on the operation itself.
    $applies = parent::applies();

    if ($applies) {
      // If the permission applies for the operation we also check the context.
      try {
        $layout = $this->getContextValue('layout');
        [, $layout_id] = explode(':', $this->getPluginId());
        if (!$layout || $layout->getLayoutId() !== $layout_id) {
          $applies = FALSE;
        }
      } catch (PluginException | ContextException $e) {
        // Do not apply if the context cannot be read.
        $applies = FALSE;
        Error::logException(\Drupal::logger('layout_builder_perms'), $e);
      }
    }

    return $applies;
  }

}
