<?php

namespace Drupal\layout_builder_perms_global\Plugin\Derivative;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\layout_builder_perms\LayoutBuilderPermissionPluginDeriverBase;

/**
 * Defines global LayoutBuilderPermission plugins.
 */
class GlobalLayoutBuilderPermissions extends LayoutBuilderPermissionPluginDeriverBase {

  use StringTranslationTrait;

  /**
   * The global section and block permissions.
   *
   * @var string[][]
   */
  protected $permissions = [
    'section_add' => [
      'permission' => 'create layout builder sections',
      'title' => 'Add Layout Builder sections',
      ],
    'section_edit' => [
      'permission' => 'edit layout builder sections',
      'title' => 'Edit Layout Builder sections',
    ],
    'section_remove' => [
      'permission' => 'remove layout builder sections',
      'title' => 'Remove Layout Builder sections',
    ],
    'block_add' => [
      'permission' => 'create layout builder blocks',
      'title' => 'Add Layout Builder blocks',
    ],
    'block_config' => [
      'permission' => 'config layout builder blocks',
      'title' => 'Configure Layout Builder blocks',
    ],
    'block_remove' => [
      'permission' => 'remove layout builder blocks',
      'title' => 'Remove Layout Builder blocks',
    ],
    'block_reorder' => [
      'permission' => 'reorder layout builder blocks',
      'title' => 'Reorder Layout builder blocks',
    ],
  ];

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    // Global permissions.
    foreach ($this->getLayoutBuilderOperations() as $operation) {
      if (isset($this->permissions[$operation])) {
        $this->derivatives[$operation] = $base_plugin_definition;
        $this->derivatives[$operation]['permission'] = $this->permissions[$operation]['permission'];
        $this->derivatives[$operation]['label'] = $this->permissions[$operation]['title'];
        $this->derivatives[$operation]['description'] = '';
        $this->derivatives[$operation]['operation'] = $operation;
      }
    }
    return $this->derivatives;
  }

}
