<?php

namespace Drupal\layout_builder_perms_node\Plugin\LayoutBuilderPermission;

use Drupal\Component\Plugin\Exception\ContextException;
use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\Utility\Error;
use Drupal\layout_builder_perms\LayoutBuilderPermissionBase;

/**
 * Discovers global LayoutBuilderPermission plugins.
 *
 * @LayoutBuilderPermission(
 *   id = "content_type",
 *   context_definitions = {
 *     "entity" = @ContextDefinition("entity", label = @Translation("Entity"), required = TRUE),
 *     "operation" = @ContextDefinition("string", label = @Translation("Operation"), required = TRUE)
 *   },
 *   deriver = "Drupal\layout_builder_perms_node\Plugin\Derivative\NodeLayoutBuilderPermissions"
 * )
 */
class NodePermission extends LayoutBuilderPermissionBase {

  /**
   * {@inheritdoc}
   */
  public function applies(): bool {
    // Let the parent check on the operation itself.
    $applies = parent::applies();

    if ($applies) {
      // If the permission applies for the operation we also check the context.
      try {
        $entity = $this->getContextValue('entity');
        [, $content_type] = explode(':', $this->getPluginId());
        if (!$entity || $entity->getEntityTypeId() !== 'node' || $entity->getType() !== $content_type) {
          $applies = FALSE;
        }
      } catch (PluginException | ContextException $e) {
        // Do not apply if the context cannot be read.
        $applies = FALSE;
        Error::logException(\Drupal::logger('layout_builder_perms'), $e);
      }
    }

    return $applies;
  }

}
