<?php

namespace Drupal\layout_builder_perms;

use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\layout_builder\SectionStorageInterface;

/**
 * Defines an interface for layout builder permission access managers.
 */
interface AccessManagerInterface {

  /**
   * Available layout builder operations.
   */
  const LAYOUT_BUILDER_OPERATIONS = [
    'block_reorder',
    'block_add',
    'block_config',
    'block_remove',
    'section_add',
    'section_edit',
    'section_remove',
  ];

  /**
   * Returns the access result as determined by all permission plugins together.
   *
   * @param string $operation
   *   The operation to check access for.
   * @param \Drupal\Core\Routing\RouteMatchInterface|null $route_match
   *   (optional) The route match of the route to check access for.
   * @param \Drupal\layout_builder\SectionStorageInterface|null $section_storage
   *   (optional) The section storage for the layout that is being edited.
   * @param \Drupal\Core\Session\AccountInterface|null $account
   *   (optional) The account to check access for. Defaults to current user.
   * @param bool $return_as_object
   *   (optional) Defaults to FALSE.
   *
   * @return \Drupal\Core\Access\AccessResultInterface|bool
   *   The result of the combined access checks.
   */
  public function access(string $operation, RouteMatchInterface $route_match = NULL, SectionStorageInterface $section_storage = NULL, AccountInterface $account = NULL, $return_as_object = FALSE);

}
