<?php

namespace Drupal\layout_builder_perms\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\layout_builder\SectionStorageInterface;
use Drupal\layout_builder_perms\LayoutBuilderPermissionInterface;

/**
 * Defines an event for adding plugin contexts to layout builder permissions.
 */
class LayoutBuilderPermissionPluginContexts extends Event {

  const EVENT_NAME = 'layout_builder_permission_plugin_contexts';

  /**
   * The layout builder permission plugin that contexts are added to.
   *
   * @var \Drupal\layout_builder_perms\LayoutBuilderPermissionInterface
   */
  protected $plugin;

  /**
   * The operation to check access for.
   *
   * @var string
   */
  protected $operation;

  /**
   * The route match of the route to check access for.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected $routeMatch;

  /**
   * The section storage for the layout that is being edited.
   *
   * @var \Drupal\layout_builder\SectionStorageInterface
   */
  protected $sectionStorage;

  /**
   * LayoutBuilderPermissionPluginContexts constructor.
   *
   * @param \Drupal\layout_builder_perms\LayoutBuilderPermissionInterface $plugin
   *   The layout builder permission plugin that contexts are added to.
   * @param string $operation
   *   The operation to check access for.
   * @param \Drupal\Core\Routing\RouteMatchInterface|null $route_match
   *   The route match of the route to check access for.
   * @param \Drupal\layout_builder\SectionStorageInterface|null $section_storage
   *   The section storage for the layout that is being edited.
   */
  public function __construct(LayoutBuilderPermissionInterface $plugin, string $operation, RouteMatchInterface $route_match, SectionStorageInterface $section_storage) {
    $this->plugin = $plugin;
    $this->operation = $operation;
    $this->routeMatch = $route_match;
    $this->sectionStorage = $section_storage;
  }

  /**
   * Returns the layout builder permission plugin.
   *
   * @return \Drupal\layout_builder_perms\LayoutBuilderPermissionInterface
   *   The layout builder permission plugin.
   */
  public function getPlugin(): LayoutBuilderPermissionInterface {
    return $this->plugin;
  }

  /**
   * Sets the layout builder permission plugin.
   *
   * @param \Drupal\layout_builder_perms\LayoutBuilderPermissionInterface $plugin
   *   The layout builder permission plugin.
   */
  public function setPlugin(LayoutBuilderPermissionInterface $plugin): void {
    $this->plugin = $plugin;
  }

  /**
   * Returns the operation to check access for.
   *
   * @return string
   *   The operation to check access for.
   */
  public function getOperation(): string {
    return $this->operation;
  }

  /**
   * Returns the route match of the route to check access for.
   *
   * @return \Drupal\Core\Routing\RouteMatchInterface
   *   The route match of the route to check access for.
   */
  public function getRouteMatch(): RouteMatchInterface {
    return $this->routeMatch;
  }

  /**
   * Returns the section storage for the layout that is being edited.
   *
   * @return \Drupal\layout_builder\SectionStorageInterface
   *   The section storage for the layout that is being edited.
   */
  public function getSectionStorage(): SectionStorageInterface {
    return $this->sectionStorage;
  }

}
