<?php

namespace Drupal\layout_builder_perms;

use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines an interface for LayoutBuilderPermission plugins.
 */
interface LayoutBuilderPermissionInterface {

  /**
   * Returns the permission string for this plugin.
   *
   * @return string
   */
  public function getPermission(): string;

  /**
   * Returns the label for this plugin.
   *
   * @return string
   */
  public function getLabel(): string;

  /**
   * Returns the description for this plugin.
   *
   * @return string
   */
  public function getDescription(): string;

  /**
   * Returns whether or not the permission plugin applies for a give operation.
   *
   * @return bool
   */
  public function applies(): bool;

  /**
   * @param string $operation
   *   The operation to check access for.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The account to check access for.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The result of the access check.
   */
  public function access(string $operation, AccountInterface $account): AccessResultInterface;

}
