CONTENTS OF THIS FILE
---------------------

* Introduction
* Requirements
* Installation
* Using default permissions
* Defining your own permissions


INTRODUCTION
------------

This module provides a more granular control over access to (operations in) the Drupal core Layout Builder.

* For a full description of the module visit the [project page](https://www.drupal.org/project/layout_builder_perms).

* To submit bug reports and feature suggestions or to track changes see the [issue list](https://www.drupal.org/project/issues/layout_builder_perms?categories=All).


REQUIREMENTS
------------

This module requires the following module:

* Layout Builder (included in Drupal core)


INSTALLATION
------------

1. [Install the module](https://www.drupal.org/docs/extending-drupal/installing-modules) as any other contributed module
   for Drupal.

2. Enable the sub modules that define the permissions you need (see next section).

3. Configure the permissions per role on _/admin/people/permissions_.


USING DEFAULT PERMISSIONS
------------

The Layout Builder Advanced Permissions module comes with a set of sub modules that define permissions you might like.

* Layout Builder Advanced Permissions Global: a set of global permissions for the following operations:
  * Add a section
  * Update a section
  * Remove a section
  * Add a block
  * Configure a block
  * Move a block
  * Remove a block

* Layout Builder Advanced Permissions Node: a set of per content type permissions for the following operations:
  * Add a section
  * Update a section
  * Remove a section
  * Add a block
  * Configure a block
  * Move a block
  * Remove a block


DEFINING YOUR OWN PERMISSIONS
------------

The Layout Builder Advanced Permissions module uses plugin discovery to find and apply permissions. To add your own
permissions you can add a class that extends `\Drupal\layout_builder_perms\LayoutBuilderPermissionBase` and is
annotated with the `\Drupal\layout_builder_perms\Annotation\LayoutBuilderPermission` annotation. The class file should
be created in a _./src/Plugin/LayoutBuilderPermission_ folder in your custom module.

Each plugin should define a permission for a single operation in the layout builder. Supported operations are:
* Add a section: section_add
* Update a section: section_edit
* Remove a section: section_remove
* Add a block: block_add
* Configure a block: block_config
* Move a block: block_reorder
* Remove a block: block_remove

To create a plugin for each of these operations in a given context you can use a plugin deriver. A base class
`\Drupal\layout_builder_perms\LayoutBuilderPermissionPluginDeriverBase` is available to make your life easier here.

See the Layout Builder Advanced Permissions Global sub module for an example.
