<?php

namespace Drupal\layout_builder_perms_block_types_per_layout\Plugin\LayoutBuilderPermission;

use Drupal\Component\Plugin\Exception\ContextException;
use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\Utility\Error;
use Drupal\layout_builder_perms\LayoutBuilderPermissionBase;

/**
 * Discovers inline block type in layout LayoutBuilderPermission plugins.
 *
 * @LayoutBuilderPermission(
 *   id = "inline_block_type_in_layout",
 *   context_definitions = {
 *     "block" = @ContextDefinition("entity:block_content", label = @Translation("Block content"), required = FALSE),
 *     "layout" = @ContextDefinition("layout_section", label = @Translation("Layout"), required = FALSE),
 *     "operation" = @ContextDefinition("string", label = @Translation("Operation"), required = TRUE)
 *   },
 *   deriver = "Drupal\layout_builder_perms_block_types_per_layout\Plugin\Derivative\InlineBlockTypeInLayoutPermissions"
 * )
 */
class InlineBlockTypeInLayoutPermission extends LayoutBuilderPermissionBase {

  /**
   * {@inheritdoc}
   */
  public function applies(): bool {
    // Let the parent check on the operation itself.
    $applies = parent::applies();

    if ($applies) {
      // If the permission applies for the operation we also check the context.
      try {
        $layout = $this->getContextValue('layout');
        $block = $this->getContextValue('block');
        [, $layout_id, $block_type_id] = explode(':', $this->getPluginId());
        if (!$layout || !$block || $layout->getLayoutId() !== $layout_id || $block->bundle() !== $block_type_id) {
          $applies = FALSE;
        }
      } catch (PluginException | ContextException $e) {
        // Do not apply if the context cannot be read.
        $applies = FALSE;
        Error::logException(\Drupal::logger('layout_builder_perms'), $e);
      }
    }

    return $applies;
  }

}
