<?php

namespace Drupal\layout_builder_perms_layout_type\Plugin\Derivative;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Layout\LayoutPluginManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\layout_builder_perms\LayoutBuilderPermissionPluginDeriverBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines layout type LayoutBuilderPermission plugins.
 */
class LayoutTypePermissions extends LayoutBuilderPermissionPluginDeriverBase implements ContainerDeriverInterface {

  /**
   * The layout plugin manager.
   *
   * @var \Drupal\Core\Layout\LayoutPluginManagerInterface
   */
  protected $layoutPluginManager;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * LayoutLayoutBuilderPermissions constructor.
   *
   * @param \Drupal\Core\Layout\LayoutPluginManagerInterface $layout_plugin_manager
   *   The layout plugin manager.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(LayoutPluginManagerInterface $layout_plugin_manager, EntityTypeManagerInterface $entity_type_manager) {
    $this->layoutPluginManager = $layout_plugin_manager;
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('plugin.manager.core.layout'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    // Per layout.
    foreach ($this->layoutPluginManager->getLayoutOptions() as $layout_group) {
      foreach ($layout_group as $layout_id => $layout_name) {
        if ($layout_name) {
          // Per operation.
          foreach (['section_add', 'section_edit', 'section_remove'] as $operation) {
            [, $action] = explode('_', $operation);
            $plugin_id = $layout_id . ':' . $operation . ':' . $action;
            $this->derivatives[$plugin_id] = $base_plugin_definition;
            $this->derivatives[$plugin_id]['permission'] =
              $action . ' ' . 'layouts of type ' . $layout_id;
            $this->derivatives[$plugin_id]['label'] =
              ucfirst($action) . ' ' . 'layouts of type ' . $layout_name->getUntranslatedString();
            $this->derivatives[$plugin_id]['description'] = '';
            $this->derivatives[$plugin_id]['operation'] = $operation;

            // Choosing a layout for a section and configuring a section use
            // the same route and thus the same operation. Let's add an
            // additional derivative for the second case.
            if ('section_edit' === $operation) {
              $action = 'add';
              $plugin_id = $layout_id . ':' . $operation. ':' . $action;
              $this->derivatives[$plugin_id] = $base_plugin_definition;
              $this->derivatives[$plugin_id]['permission'] =
                $action . ' ' . 'layouts of type ' . $layout_id;
              $this->derivatives[$plugin_id]['label'] =
                ucfirst($action) . ' ' . 'layouts of type ' . $layout_name->getUntranslatedString();
              $this->derivatives[$plugin_id]['description'] = '';
              $this->derivatives[$plugin_id]['operation'] = $operation;
              $this->derivatives[$plugin_id]['action'] = $action;
              $this->derivatives[$plugin_id]['layout'] = $layout_id;
            }
          }
        }
      }
    }
    return $this->derivatives;
  }

}
