<?php

namespace Drupal\layout_builder_perms_layout_type\Plugin\LayoutBuilderPermission;

use Drupal\Component\Plugin\Exception\ContextException;
use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\Utility\Error;
use Drupal\layout_builder_perms\LayoutBuilderPermissionBase;

/**
 * Discovers layout type LayoutBuilderPermission plugins.
 *
 * @LayoutBuilderPermission(
 *   id = "layout_type",
 *   context_definitions = {
 *     "layout" = @ContextDefinition("layout_section", label = @Translation("Layout"), required = FALSE),
 *     "operation" = @ContextDefinition("string", label = @Translation("Operation"), required = TRUE)
 *   },
 *   deriver = "Drupal\layout_builder_perms_layout_type\Plugin\Derivative\LayoutTypePermissions"
 * )
 */
class LayoutTypePermission extends LayoutBuilderPermissionBase {

  /**
   * {@inheritdoc}
   */
  public function applies(): bool {
    // Let the parent check on the operation itself.
    $applies = parent::applies();

    if ($applies) {
      // If the permission applies for the operation we also check the context.
      try {
        $layout = $this->getContextValue('layout');
        [, $layout_id, $operation, $action] = explode(':', $this->getPluginId());

        // Check if we are gathering permissions for the action this plugin
        // cares about.
        if ('section_edit' === $operation && 'add' === $action) {
          $applies = $layout->getThirdPartySetting('layout_builder_perms', 'action', 'edit') === 'add';
        }

        // Check if we are gathering permissions for the layout and bundle this
        // plugin cares about.
        if (!$layout || $layout->getLayoutId() !== $layout_id) {
          $applies = FALSE;
        }
      } catch (PluginException | ContextException $e) {
        // Do not apply if the context cannot be read.
        $applies = FALSE;
        Error::logException(\Drupal::logger('layout_builder_perms'), $e);
      }
    }

    return $applies;
  }

}
