<?php

namespace Drupal\layout_builder_perms\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a LayoutBuilderPermission annotation object.
 *
 * @Annotation
 */
class LayoutBuilderPermission extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The permission string.
   *
   * @var string
   */
  public $permission;

  /**
   * The human-readable name of the formatter type.
   *
   * @var \Drupal\Core\Annotation\Translation
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A short description of the formatter type.
   *
   * @var \Drupal\Core\Annotation\Translation
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The layout builder operation this permission determines access to.
   *
   * @var string
   */
  public $operation;

}
