<?php

namespace Drupal\layout_builder_perms;

use Drupal\layout_builder_perms\Event\LayoutBuilderPermissionPluginContexts;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Provides a base class for event subscribers that add contexts to plugins.
 */
abstract class LayoutBuilderPermissionPluginContextProviderBase implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [LayoutBuilderPermissionPluginContexts::class => 'addPluginContexts'];
  }

  /**
   * Adds plugin contexts to layout builder permission plugins.
   *
   * Implementing classes should make sure that they check whether the plugin
   * defines the context the class will add to prevent errors. See the access
   * manager in this module for examples.
   * @see \Drupal\layout_builder_perms\Access\AccessManager::setPluginContext()
   *
   * @param \Drupal\layout_builder_perms\Event\LayoutBuilderPermissionPluginContexts $event
   *   The layout builder permission plugin contexts event.
   */
  abstract function addPluginContexts(LayoutBuilderPermissionPluginContexts $event): void;

}
