<?php

namespace Drupal\layout_builder_perms;

/**
 * Defines an interface for LayoutBuilderPermission plugin managers.
 */
interface LayoutBuilderPermissionPluginManagerInterface {

  /**
   * Returns all LayoutBuilderPermission plugins.
   *
   * @param array $filters
   *   A list of plugin definition filters to get a selected list of plugins.
   *   For example: operation, component, action, layout, block_type,
   *   entity_type or bundle.
   *
   * @return \Drupal\layout_builder_perms\LayoutBuilderPermissionInterface[]
   *   Array of LayoutBuilderPermission plugins.
   */
  public function getPermissionPlugins($filters = []): array;

}
