# Layout Builder Reusable Blocks

A Drupal module that enables editors to create and edit reusable custom blocks directly from Layout Builder, without navigating to the Custom Block Library.

## Overview

This module addresses a significant workflow improvement for content editors working with Drupal's Layout Builder. Instead of requiring editors to navigate between Layout Builder and the Custom Block Library to create reusable blocks, this module provides an integrated solution that allows:

- Creating blocks directly in Layout Builder with a choice between inline and reusable
- Converting existing inline blocks to reusable blocks
- Editing reusable blocks directly within the Layout Builder interface
- Configurable default behavior and permissions

## Problem Solved

This module addresses [Drupal Core Issue #2999491](https://www.drupal.org/project/drupal/issues/2999491) - "Add reusable option to inline block creation". Rather than waiting for this functionality to be included in Drupal core or applying patches that may become outdated, we implemented this as a standalone module that provides a stable, maintainable solution.

### Why Not Use Patches?

The core issue has been under discussion since 2018 with numerous patches and approaches. Rather than maintaining complex patches that require updates with each Drupal release, this module provides:

- **Stability**: No need to reapply patches during Drupal updates
- **Maintainability**: Module updates independent of core updates
- **Flexibility**: Configurable options not available in proposed patches
- **Production Ready**: Thoroughly tested implementation ready for production use

## Features

### Block Creation Workflow

The module modifies the Layout Builder "Add Block" workflow to provide choice between block types:

1. **Two-Step Block Creation**: When adding a new custom block, users first choose the block type (inline or reusable)
2. **Clear Descriptions**: Helpful explanations of the difference between inline and reusable blocks
3. **Admin Title Field**: For reusable blocks, provides an admin title field for easy identification

### Block Management

- **Convert to Reusable**: Contextual link on inline blocks to convert them to reusable
- **Edit Reusable Blocks**: Edit reusable block content directly in Layout Builder
- **Warning Messages**: Configurable warnings when editing reusable blocks to inform users that changes affect all instances

### Configuration Options

Navigate to **Configuration > User interface > Layout Builder Reusable Blocks** (`/admin/config/user-interface/layout-builder-reusable-blocks`) to configure:

#### Warning Message Settings
- Toggle warning messages on/off when editing reusable blocks
- Customize warning message text
- Helps users understand the global impact of their changes

#### Block Behavior Settings
- **Allow editing reusable blocks**: Control whether reusable blocks can be edited from Layout Builder
- **Make all blocks reusable by default**: Skip the choice and automatically create all blocks as reusable

## Installation

1. Download and extract the module to your modules directory
2. Enable the module: `drush en layout_builder_reusable_blocks`
3. Configure settings at `/admin/config/user-interface/layout-builder-reusable-blocks`

## Requirements

- Drupal 10 or 11
- Layout Builder module (core)
- Block Content module (core)

## Permissions

The module adds the following permission:

- **Administer Layout Builder Reusable Blocks**: Configure module settings

Block creation and editing permissions are controlled by existing Drupal permissions:
- Create and edit custom blocks
- Use layout builder

## Technical Implementation

### Form Alterations

The module uses `hook_form_FORM_ID_alter()` to modify the Layout Builder add block form, providing:

- Multi-step form for block type selection
- Dynamic form fields based on user choices
- AJAX-powered interface for smooth user experience

### Block Plugin Override

The module provides a custom block plugin (`LayoutBuilderReusableContentBlock`) that extends the core `BlockContentBlock` to add:

- Enhanced configuration forms for Layout Builder context
- Warning messages for reusable blocks
- Proper form validation and submission handling

### Configuration Management

All settings are stored in configuration (`layout_builder_reusable_blocks.settings`) allowing for:

- Export/import with configuration management
- Environment-specific settings
- Programmatic configuration updates

## Configuration

### Default Settings

The module provides sensible defaults:
- Warning messages enabled
- Editing of reusable blocks disabled by default
- Individual block type choice (not forced to reusable)

### Customization Options

- **Warning Message Text**: Customize the text shown when editing reusable blocks
- **Block Behavior**: Choose between allowing individual choice or forcing all blocks to be reusable
- **Access Control**: Configure which users can access different features

## Usage Examples

### Creating a Reusable Block

1. Navigate to Layout Builder for any entity
2. Click "Add Block" → "Create custom block"
3. Choose "Create reusable block"
4. Fill in the admin title and block content
5. Save - the block is now available in the block library

### Converting Inline to Reusable

1. On an existing inline block, click the contextual menu
2. Select "Make reusable"
3. Confirm the action in the dialog
4. The block is now available for reuse elsewhere

### Editing Reusable Blocks

1. When editing any reusable block in Layout Builder
2. A warning message appears explaining global impact
3. Make changes as needed
4. Changes apply to all instances of the block


## Contributing

This module was created by Sprintive to provide a production-ready solution while the core issue remains in development. We welcome contributions and feedback.

## Support

For support, feature requests, or bug reports, please use the project's issue queue.

## License

This project is licensed under the GPL-2.0+ license, the same as Drupal core.

---

**Developed by [Sprintive](http://sprintive.com)**

*Providing innovative Drupal solutions for modern web experiences*
