# Layout Builder Section-Block Clone

A lightweight Drupal module that adds convenient clone functionality to Layout Builder, allowing users to duplicate sections and blocks for faster content creation and layout management.

## Table of contents
- Features
- Requirements
- Installation
- Usage
- How it works

## Features
- **Section cloning**: Duplicate entire sections with all blocks and configurations
- **Block cloning**: Clone individual blocks within sections
- **Seamless integration**: Clone links appear alongside existing Layout Builder controls
- **No configuration needed**: Works out of the box after installation
- **Smart duplication**: Preserves all block settings, configurations, and visibility rules

## Requirements
- Drupal 10 or 11
- Layout Builder (core module)

## Installation

### Via Composer (Recommended)
```bash
composer require drupal/layout_builder_section_block_duplicate
drush en layout_builder_section_block_duplicate -y
```

### Manual Installation
1. Download the module from [drupal.org](https://www.drupal.org/project/layout_builder_section_block_duplicate)
2. Extract into your Drupal `modules/contrib` directory
3. Enable the module via:
   - **Admin UI**: Go to `Administration > Extend`, search for "Layout Builder Section-Block Clone", and enable it.
   - **Drush**: Run `drush en layout_builder_section_block_duplicate -y`

## Usage

### Cloning Sections
1. Enter Layout Builder mode on any page
2. Hover over a section to reveal administrative links
3. Click the "Clone section" link (appears with clone icon)
4. The section duplicates immediately below the original
5. Save your layout changes

### Cloning Blocks
1. In Layout Builder mode, hover over any block
2. Click the contextual links button
3. Select "Clone block" from the dropdown menu
4. The block clones and appears after the original
5. Save your layout changes

## How It Works
The module:
1. Integrates clone links into Layout Builder's existing interface
2. Provides section cloning via `CloneSectionController` alongside configure/remove options
3. Adds block cloning through contextual links using `CloneBlockForm`
4. Preserves all original configurations and settings during duplication

Example:
```
Original section → Clone section link → Duplicated section (with all blocks)
Original block → Contextual clone link → Duplicated block (with same config)
```