<?php

namespace Drupal\layout_builder_section_block_duplicate\Hook;

/**
 * Hook subscriber for Layout Builder Section Block Duplicate module.
 */
class BlockDuplicateHooks {

  /**
   * Implements hook_page_attachments().
   */
  public function pageAttachments(array &$attachments) {
    $attachments['#attached']['library'][] = 'layout_builder_section_block_duplicate/layout_builder_section_block_duplicate_css';
  }

  /**
   * Implements hook_element_info_alter().
   */
  public function alterElementInfo(array &$types) {
    if (isset($types['layout_builder']['#pre_render'])) {
      $types['layout_builder']['#pre_render'][] = [
        '\Drupal\layout_builder_section_block_duplicate\LayoutBuilderAlter',
        'addCustomLink',
      ];
    }
  }

}
