<?php

namespace Drupal\layout_paragraphs_restrictions;

use Drupal\Core\Security\TrustedCallbackInterface;

/**
 * A class to alter the mercury_editor_component_outline render element.
 */
class MercuryEditorComponentOulineAlter implements TrustedCallbackInterface {

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks() {
    return ['alter'];
  }

  /**
   * Alters the ME component outline render element to add data attributes.
   */
  public static function alter(array &$element) {
    $tempstore_service = \Drupal::service('layout_paragraphs.tempstore_repository');
    $layout_id = $element['component-tree'][0]['#props']['layout_id'];
    $layout = $tempstore_service->getWithStorageKey($layout_id);
    if ($layout) {
      $entity = $layout->getEntity();
      $field_name = $layout->getFieldName() ?? '';
      $entity_type = $entity->getEntityTypeId() ?? '';
      $entity_bundle = $entity->bundle() ?? '';
    }
    $element['#attached']['library'][] = 'layout_paragraphs_restrictions/restrictions';
    $restrictions = \Drupal::configFactory()->get('layout_paragraphs_restrictions.settings')->get('restrictions');
    if (!empty($restrictions)) {
      $element['#attached']['drupalSettings']['lpBuilder']['restrictions'][$layout_id] = array_values($restrictions);
    }
    $element['component-tree'][0]['#props']['attributes']->setAttribute('data-lpb-id', $layout_id);
    $element['component-tree'][0]['#props']['attributes']->setAttribute('data-lp-reference-field', $field_name);
    $element['component-tree'][0]['#props']['attributes']->setAttribute('data-lp-entity-type', $entity_type);
    $element['component-tree'][0]['#props']['attributes']->setAttribute('data-lp-entity-bundle', $entity_bundle);
    self::recursiveAddDataAttributes($element['component-tree'][0]['#props']['items']);
    return $element;
  }

  /**
   * Recursively adds data attributes to each item in the component tree.
   */
  public static function recursiveAddDataAttributes(array &$items) {
    foreach ($items as &$item) {
      if (isset($item['attributes']) && isset($item['entity'])) {
        $paragraph = $item['entity'];
        $item['attributes']->setAttribute('data-lp-component-type', $paragraph->bundle());
        $behaviorSettings = $paragraph->getAllBehaviorSettings();
        foreach ($behaviorSettings['style_options'] ?? [] as $style_option) {
          if (!empty($style_option['component_variation'])) {
            $current_value = $item['attributes']->getAttribute('data-lp-component-type');
            $item['attributes']->setAttribute('data-lp-component-type', $current_value . '__' . $style_option['component_variation']);
          }
        }
      }
      if (isset($item['children']) && is_array($item['children'])) {
        self::recursiveAddDataAttributes($item['children']);
      }
    }
  }

}
