# Layout Paragraphs Restrictions - Duplication Support

This module now supports preventing duplication when max_items restrictions would be violated.

## How it works

When a user attempts to duplicate a component, the `LayoutParagraphsRestrictions` event subscriber will:

1. Check the target location where the duplicate would be placed
2. Count existing components in that location
3. Apply any matching restriction rules that have `max_items` configured
4. Prevent duplication if limits would be exceeded
5. Show a user-friendly message explaining why duplication was blocked

## Example Configuration

```yaml
# Prevent duplication when total items would exceed 3 in a two-column layout's first region
maximum_items_example:
  context:
    layout: layout_twocol
    region: first
  max_items:
    # Allows three items of any type in the first column
    _total: 3
    # Allows only one heading in the first column
    heading: 1

# Prevent duplication of CTA components in CTA lists when limit is reached
cta_list_max_items:
  context:
    parent_type: cta_list
  max_items:
    # Only allow 5 CTA components total in any CTA list
    cta: 5
```

## User Experience

When duplication is prevented, users will see a dialog with one of these messages:

- "Cannot duplicate: Maximum total items (3) reached for this location."
- "Cannot duplicate: Maximum items of type 'heading' (1) reached for this location."

## Technical Details

- The `duplicateRestrictions()` method is called for every duplication attempt
- It uses the same restriction rule matching logic as the type restrictions
- Component counts are calculated for the target location
- Custom messages clearly explain why duplication was blocked
- The duplicated component is automatically removed when duplication is prevented

## Testing

To test this functionality:

1. Configure a max_items restriction for a specific layout/region/parent
2. Add components until you reach the limit
3. Try to duplicate an existing component
4. Verify that duplication is prevented with an appropriate message
