/**
 * Edit layout block.
 *
 * @param url
 */
jQuery.fn.LBPlusEditLayout = (url) => {
  let ajax = Drupal.NavigationPlus.ModePluginBase.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    progress: {
      type: 'fullscreen',
      message: Drupal.t('Loading Layout Builder...')
    },
    error: error => {
      document.querySelectorAll('.ajax-progress').forEach(progress => {
        progress.remove();
      });
      console.info('Attempted to load a Layout Builder UI for a nested layout block');
      console.info(url);
      console.info(error.responseText);
    },
    success: (response, status) => {
      Promise.resolve(
        Drupal.Ajax.prototype.success.call(ajax, response, status)
      );
    }
  });
  ajax.execute();
};
