<?php

namespace Drupal\lb_plus\EventSubscriber;

use Drupal\Core\Url;
use Drupal\lb_plus\Event\BlockToolIndicatorEvent;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Layout Builder + event subscriber.
 */
class BlockToolIndicators implements EventSubscriberInterface {

  use StringTranslationTrait;

  public function __construct(
    protected ModuleHandlerInterface $moduleHandler,
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {}

  public function onToolIndicator(BlockToolIndicatorEvent $event) {
    $build = $event->getBuild();
    $nested_storage_path = $event->isIsLayoutBlock() ? '' : $event->getNestedStoragePath();

    // Delete block.
    $build['#attached']['drupalSettings']['navigationPlus']['toolIndicators']['links']['remove_block'][$event->getUuid()] = Url::fromRoute('lb_plus.contextual_link.remove_block', [
      'section_storage_type' => $event->getStorageType(),
      'section_storage' => $event->getStorageId(),
      'delta' => $event->getSectionDelta(),
      'region' => $event->getRegion(),
      'uuid' => $event->getUuid(),
      'nested_storage_path' => $nested_storage_path,
    ])->toString();

    // Configure block.
    $build['#attached']['drupalSettings']['navigationPlus']['toolIndicators']['links']['configure'][$event->getUuid()] = Url::fromRoute('lb_plus.contextual_link.update_block', [
      'section_storage_type' => $event->getStorageType(),
      'section_storage' => $event->getStorageId(),
      'delta' => $event->getSectionDelta(),
      'region' => $event->getRegion(),
      'uuid' => $event->getUuid(),
      'nested_storage_path' => $nested_storage_path,
    ])->toString();

    // Duplicate block.
    $build['#attached']['drupalSettings']['navigationPlus']['toolIndicators']['links']['duplicate'][$event->getUuid()] = Url::fromRoute('lb_plus.contextual_link.duplicate_block', [
      'section_storage_type' => $event->getStorageType(),
      'section_storage' => $event->getStorageId(),
      'delta' => $event->getSectionDelta(),
      'region' => $event->getRegion(),
      'uuid' => $event->getUuid(),
      'nested_storage_path' => $nested_storage_path,
    ])->toString();

    if ($event->isIsLayoutBlock()) {
      // Edit layout block.
      $build['#attached']['drupalSettings']['navigationPlus']['toolIndicators']['links']['edit_layout_block'][$event->getUuid()] = Url::fromRoute('lb_plus.contextual_link.layout_block.edit', [
        'section_storage_type' => $event->getStorageType(),
        'section_storage' => $event->getStorageId(),
        'nested_storage_path' => $event->getNestedStoragePath(),
      ])->toString();
    }
    $event->setBuild($build);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      BlockToolIndicatorEvent::class => ['onToolIndicator'],
    ];
  }

}
