export const editLayoutBlock = (url) => {
  let ajax = Drupal.NavigationPlus.ModePluginBase.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    progress: {
      type: 'fullscreen',
      message: Drupal.t('Loading block layout...')
    },
    error: error => {
      document.querySelectorAll('.ajax-progress').forEach(progress => {
        progress.remove();
      });
      console.error('Attempted to load a Layout Builder UI for a nested layout block', url);
      console.error(error.responseText);
      Drupal.NavigationPlus.ModeManager.getPlugin('edit').message("Failed to edit this Layout Block.");
    },
    success: (response, status) => {
      Promise.resolve(
        Drupal.Ajax.prototype.success.call(ajax, response, status)
      );
    }
  });
  ajax.execute();

  // Don't allow the change tool in nested layouts.
  const currentTool = window.currentTool();
  if (currentTool === 'edit_plus') {
    Drupal.NavigationPlus.ModeManager.getPlugin('edit').changeTool('pointer');
  }

}
