import { changeSectionLayout } from '../shared/change-section-layout.js';
import { editLayoutBlock } from '../shared/edit-layout-block.js';

export const registerLayoutIndicators = () => {

  /**
   * Registers the layout indicator configuration with the Navigation+ tool indicators manager.
   */
  if (typeof window.registerToolIndicatorConfig === 'function') {
    const layoutIndicators = [
      {
        type: 'section',
        icon: drupalSettings.navigationPlus.toolIndicators.icons['layout_tool'] ?? null,
        handlers: {
          onClick: (e) => {
            const sectionUuid = e.target.closest('.layout-builder__section').id;
            changeSectionLayout(sectionUuid);
          },
        },
      },
      {
        type: 'block',
        icon: drupalSettings.navigationPlus.toolIndicators.icons['layout_tool'] ?? null,
        alwaysOn: true,
        enabler: (indicatorWrapper) => {
          return !!indicatorWrapper.closest('.lb-plus-layout-block');
        },
        handlers: {
          onClick: (e) => {
            const blockUuid = e.target.closest('[data-layout-builder-block-uuid]').dataset.layoutBuilderBlockUuid;
            const url = drupalSettings.navigationPlus.toolIndicators.links.edit_layout_block[blockUuid];
            editLayoutBlock(url);
          },
        },
      },
    ];

    window.registerToolIndicatorConfig('layout_tool', layoutIndicators);
  }
};
