export const configureSection = (sectionUuid) => {
  const section = document.querySelector(`.layout-builder__section[id="${sectionUuid}"]`);
  const sectionStorageInfo = Drupal.NavigationPlus.ModeManager.getPlugin('edit').getSectionStorageInfo(section);

  let path = `/lb-plus/configure/section/${sectionStorageInfo.storageType}/${sectionStorageInfo.storageId}/${sectionStorageInfo.sectionDelta}`;
  if (sectionStorageInfo.nestedStoragePath) {
    path += '/' + sectionStorageInfo.nestedStoragePath;
  }
  const url = Drupal.NavigationPlus.ModePluginBase.url(path, {section_delta: sectionStorageInfo.sectionDelta});

  Drupal.NavigationPlus.ModePluginBase.dialog({
    url: url,
    width: 900,
    message: Drupal.t('Configuring section...'),
  });
}
