import { configureSection } from '../shared/configure-section.js';

export const registerConfigureIndicators = () => {

  /**
   * Registers the "configure indicator" configuration with the Navigation+ tool
   * indicators manager.
   */
  if (typeof window.registerToolIndicatorConfig === 'function') {
    const configureIndicators = [
      {
        type: 'section',
        icon: drupalSettings.navigationPlus.toolIndicators.icons['configure'] ?? null,
        handlers: {
          onClick: (e) => {
            const sectionUuid = e.target.closest('.layout-builder__section').id;
            configureSection(sectionUuid);
          },
        },
      },
      {
        type: 'block',
        icon: drupalSettings.navigationPlus.toolIndicators.icons['configure'] ?? null,
        handlers: {
          onClick: (e) => {

            const blockUuid = e.target.closest('[data-layout-builder-block-uuid]').dataset.layoutBuilderBlockUuid;
            const url = drupalSettings.navigationPlus.toolIndicators.links.configure[blockUuid];

            Drupal.NavigationPlus.ModePluginBase.dialog({
              url: url,
              width: 900,
              message: Drupal.t('Configuring block...'),
            });
          },
        },
      },
    ];


    window.registerToolIndicatorConfig('configure', configureIndicators);
  }
};
