<?php

namespace Drupal\lb_plus;

use Drupal\Core\TempStore\SharedTempStoreFactory;
use Drupal\page_manager_ui\LayoutBuilderTempstoreRepository;

/**
 * Workspace-aware version of Page Manager's Layout Builder tempstore repository.
 *
 * This extends page_manager_ui's LayoutBuilderTempstoreRepository to add
 * workspace and langcode awareness to tempstore keys.
 */
class WorkspaceAwarePageManagerLayoutTempstoreRepository extends LayoutBuilderTempstoreRepository {

  use WorkspaceAwareTempstoreTrait;

  /**
   * Constructs a WorkspaceAwarePageManagerLayoutTempstoreRepository object.
   *
   * @param \Drupal\Core\TempStore\SharedTempStoreFactory $tempStoreFactory
   *   The tempstore factory.
   * @param \Drupal\workspaces\WorkspaceManagerInterface|null $workspaceManager
   *   The workspace manager, or NULL if workspaces module is not enabled.
   */
  public function __construct(
    SharedTempStoreFactory $tempStoreFactory,
    protected $workspaceManager = NULL,
  ) {
    parent::__construct($tempStoreFactory);
  }

}
