<?php

namespace Drupal\lb_plus;

use Drupal\Core\TempStore\SharedTempStoreFactory;
use Drupal\layout_builder\LayoutTempstoreRepository;

/**
 * Provides workspace-aware layout tempstore repository.
 *
 * Extends core's LayoutTempstoreRepository to include workspace ID and
 * langcode in tempstore keys, preventing cross-workspace collisions.
 */
class WorkspaceAwareLayoutTempstoreRepository extends LayoutTempstoreRepository {

  use WorkspaceAwareTempstoreTrait;

  /**
   * Constructs a WorkspaceAwareLayoutTempstoreRepository.
   *
   * @param \Drupal\Core\TempStore\SharedTempStoreFactory $tempStoreFactory
   *   The shared tempstore factory.
   * @param \Drupal\workspaces\WorkspaceManagerInterface|null $workspaceManager
   *   The workspace manager service (optional, only present when workspaces
   *   module is enabled).
   */
  public function __construct(
    SharedTempStoreFactory $tempStoreFactory,
    protected $workspaceManager = NULL,
  ) {
    parent::__construct($tempStoreFactory);
  }

}
