export const registerDuplicateIndicators = () => {

  /**
   * Registers the duplicate indicator configuration with the Navigation+ tool indicators manager.
   */
  if (typeof window.registerToolIndicatorConfig === 'function') {
    const duplicateIndicators = [
      {
        type: 'block',
        icon: drupalSettings.navigationPlus.toolIndicators.icons['duplicate'] ?? null,
        handlers: {
          onClick: (e) => {

            const blockUuid = e.target.closest('[data-layout-builder-block-uuid]').dataset.layoutBuilderBlockUuid;
            const url = drupalSettings.navigationPlus.toolIndicators.links.duplicate[blockUuid];

            const ajaxConfig = {
              url: url,
              event: 'click',
              progress: {
                type: 'fullscreen',
                message: Drupal.t('Duplicating block...'),
              },
              error: error => {
                console.error('Unable to duplicate block: ', error.responseText || error);
                Drupal.NavigationPlus.ModeManager.getPlugin('edit').handleError(error, 'Unable to duplicate block.');
              },
            };

            let ajax = Drupal.NavigationPlus.ModePluginBase.ajax(ajaxConfig);
            ajax.execute();
          },
        },
      },
    ];

    window.registerToolIndicatorConfig('duplicate', duplicateIndicators);
  }
};
