<?php

namespace Drupal\lb_plus;

use Drupal\Core\Entity\EntityDisplayRepositoryInterface;
use Drupal\Core\Entity\EntityInterface;

trait LbPlusToolTrait {

  /**
   * @var \Drupal\Core\Entity\EntityDisplayRepositoryInterface
   */
  protected $entityDisplayRepository;

  public function lbPlusToolApplies(EntityInterface $entity) {

    $entity_type_id = $entity->getEntityTypeId();
    $bundle = $entity->bundle();

    // @todo We are getting the entity from NavigationPlusUi->deriveEntityFromRoute.
    // @todo We need to figure out a way to get the actual view mode here and
    // @todo not hard code 'default'.
    $view_display = $this->entityDisplayRepository()->getViewDisplay($entity_type_id, $bundle, 'default');

    if ($view_display) {
      // Check if Layout Builder is enabled for this view display.
      return !empty($view_display->getThirdPartySetting('layout_builder', 'enabled', FALSE));
    }
    return FALSE;
  }


  protected function entityDisplayRepository(): EntityDisplayRepositoryInterface {
    return $this->entityDisplayRepository ?: \Drupal::service('entity_display.repository');
  }

}
